// requires: kubejsadditions
// requires: resourceful_tools

const recipes = {
  hand_tiller: ["resourceful_tools:hand_tiller", "resourceful_tools:hand_tiller_copper"],
  hook_knife: ["resourceful_tools:hook_knife", "resourceful_tools:hook_knife_copper"],
  hand_pick: ["resourceful_tools:hand_pick", "resourceful_tools:hand_pick_copper"],
  hand_scraper: ["resourceful_tools:hand_scraper", "resourceful_tools:hand_scraper_copper"],
  tree_trimmer: ["resourceful_tools:tree_trimmer", "resourceful_tools:tree_trimmer_copper"],
  clam_digger: ["resourceful_tools:clam_digger", "resourceful_tools:clam_digger_copper"],
};

Object.entries(recipes).forEach((/** @type {[String, String[]]} */ [key, catalysts]) => {
  /** @type {Internal.RecipeCategoryBuilder<Internal.CustomJSRecipe>} */
  let recipeCategory;
  JEIAddedEvents.registerCategories((event) => {
    event.custom(`kubejs:resourceful_tools/${key}`, (category) => {
      const {
        jeiHelpers,
        jeiHelpers: { guiHelper },
      } = category;

      category
        .title(Text.translate(`jei.kubejs.resourceful_tools.${key}`))
        .background(guiHelper.createBlankDrawable(75, 16))
        .icon(guiHelper.createDrawableItemStack(Item.of(catalysts[0])))
        .isRecipeHandled((recipe) => verifyRecipeFn(jeiHelpers, recipe))
        .handleLookup((builder, recipe, focuses) => handleLookup(jeiHelpers, builder, recipe, focuses))
        .setDrawHandler((recipe, recipeSlotsView, guiGraphics, mouseX, mouseY) =>
          drawHandler(jeiHelpers, recipe, recipeSlotsView, guiGraphics, mouseX, mouseY)
        );

      recipeCategory = category.recipeType;
    });
  });

  JEIAddedEvents.registerRecipeCatalysts((event) => {
    catalysts.forEach((catalyst) => {
      event.data["addRecipeCatalyst(net.minecraft.world.item.ItemStack,mezz.jei.api.recipe.RecipeType[])"](catalyst, recipeCategory)
    });
  });

  ClientEvents.lang("en_us", (event) => {
    event.add(
      `jei.kubejs.resourceful_tools.${key}`,
      key
        .split("_")
        .map((word) => Utils.toTitleCase(word))
        .join(" ")
    );
  });
});

/**
 * @param {Internal.IJeiHelpers_} jeiHelpers
 * @param {Internal.CustomJSRecipe_} recipe
 * @returns {boolean}
 */
const verifyRecipeFn = (jeiHelpers, recipe) => {
  return !!(recipe?.data?.ingredient !== undefined && recipe?.data?.result !== undefined);
};

/**
 * @param {Internal.IJeiHelpers_} jeiHelpers
 * @param {Internal.IRecipeLayoutBuilder_} builder
 * @param {Internal.CustomJSRecipe_} recipe
 * @param {Internal.IFocusGroup_} focuses
 * @returns {void}
 */
const handleLookup = (jeiHelpers, builder, recipe, focuses) => {
  builder
    .addSlot("input", 0, 0.5)
    // .setSlotName("input")
    .setBackground(jeiHelpers.guiHelper.getSlotDrawable(), -1, -1)
    .addIngredients([Ingredient.of(recipe.data.ingredient)]);
  builder
    .addSlot("output", 59, 0.5)
    // .setSlotName("output")
    .setBackground(jeiHelpers.guiHelper.getSlotDrawable(), -1, -1)
    .addItemStack(Item.of(recipe.data.result));
};

/**
 * @param {Internal.IJeiHelpers_} jeiHelpers
 * @param {Internal.CustomJSRecipe_} recipe
 * @param {Internal.IRecipeSlotsView_} recipeSlotsView
 * @param {Internal.GuiGraphics_} guiGraphics
 * @param {number} mouseX
 * @param {number} mouseY
 */
const drawHandler = (jeiHelpers, recipe, recipeSlotsView, guiGraphics, mouseX, mouseY) => {
  // todo: draw the arrow on the center of the screen
};

JEIAddedEvents.registerRecipes((event) => {
  /**
   * @type {{
   * hand_tiller: [Special.Item, Special.Item][],
   * hook_knife: [Special.Item, Special.Item][],
   * hand_pick: [Special.Item, Special.Item][],
   * hand_scraper: [Special.Item, Special.Item][],
   * tree_trimmer: [Special.Item, Special.Item][],
   * clam_digger: [Special.Item, Special.Item][],
   * }}
   */
  const recipes = {
    hand_tiller: [
      ["minecraft:gravel", "resourceful_tools:bone_fragment"],
      ["minecraft:clay", "minecraft:ink_sac"],
    ],
    hook_knife: [
      ["minecraft:sheep_spawn_egg", "minecraft:string"],
      ["#minecraft:wool", "minecraft:string"],
    ],
    hand_pick: [
      ["minecraft:sandstone", "resourceful_tools:powder_saltpeter"],
      ["minecraft:netherrack", "resourceful_tools:powder_sulfur"],
      ["minecraft:magma_block", "resourceful_tools:small_blaze_powder"],
      ["minecraft:nether_quartz_ore", "resourceful_tools:ghast_tear_fragment"],
      ["minecraft:blackstone", "resourceful_tools:netherite_fragment"],
      ["minecraft:end_stone", "resourceful_tools:nether_star_fragment"],
    ],
    tree_trimmer: [
      ["minecraft:oak_leaves", "minecraft:apple"],
      ["minecraft:birch_leaves", "minecraft:string"],
      ["minecraft:spruce_leaves", "minecraft:feather"],
      ["minecraft:jungle_leaves", "minecraft:spider_eye"],
      ["minecraft:acacia_leaves", "minecraft:rabbit_foot"],
      ["minecraft:dark_oak_leaves", "resourceful_tools:pearl_fragment"],
      ["minecraft:azalea_leaves", "minecraft:phantom_membrane"],
      ["minecraft:seagrass", "minecraft:prismarine_crystals"],
      ["minecraft:hay_block", "minecraft:egg"],
    ],
    clam_digger: [["minecraft:sand", "resourceful_tools:clam"]],
  };

  Object.entries(recipes).forEach((/**@type {[String, [String, String][]]}*/ [key, recipes]) => {
    recipes.forEach(([ingredient, result]) => {
      event.custom(`kubejs:resourceful_tools/${key}`).add({ ingredient: ingredient, result: result });
    });
  });
});
